function  [R]=compute_span_tree_init(RR,I)

N=max(max(I));%Number of cameras or images or nodes in view graph

QuaternionIP=(size(RR,2)==4);
if(~QuaternionIP)
    QQ = rotm2quat(RR);
else
    QQ=RR;
end


Q=repmat([1,0,0,0],[N,1]);
i=zeros(N,1);    i(1)=1;
while(sum(i)<N)
   SpanFlag=0;
    for j=1:size(I,2)
        if(i(I(1,j))==1&&i(I(2,j))==0)
            %Rinit(:,:,I(2,j))=RR(:,:,j)*Rinit(:,:,I(1,j)); %Dont Uncomment
            Q(I(2,j),:)=[ (QQ(j,1).*Q(I(1,j),1)-sum(QQ(j,2:4).*Q(I(1,j),2:4),2)),...  %scalar terms
                repmat(QQ(j,1),[1,3]).*Q(I(1,j),2:4) + repmat(Q(I(1,j),1),[1,3]).*QQ(j,2:4) + ...   %vector terms
                [QQ(j,3).*Q(I(1,j),4)-QQ(j,4).*Q(I(1,j),3),QQ(j,4).*Q(I(1,j),2)-QQ(j,2).*Q(I(1,j),4),QQ(j,2).*Q(I(1,j),3)-QQ(j,3).*Q(I(1,j),2)] ];   %cross product terms
            i(I(2,j))=1;
            SpanFlag=1;
        end
        if(i(I(1,j))==0&&i(I(2,j))==1)
            %Rinit(:,:,I(1,j))=RR(:,:,j)'*Rinit(:,:,I(2,j)); %Dont Uncomment
            Q(I(1,j),:)=[ (-QQ(j,1).*Q(I(2,j),1)-sum(QQ(j,2:4).*Q(I(2,j),2:4),2)),...  %scalar terms
                repmat(-QQ(j,1),[1,3]).*Q(I(2,j),2:4) + repmat(Q(I(2,j),1),[1,3]).*QQ(j,2:4) + ...   %vector terms
                [QQ(j,3).*Q(I(2,j),4)-QQ(j,4).*Q(I(2,j),3),QQ(j,4).*Q(I(2,j),2)-QQ(j,2).*Q(I(2,j),4),QQ(j,2).*Q(I(2,j),3)-QQ(j,3).*Q(I(2,j),2)] ];   %cross product terms
            i(I(1,j))=1;
            SpanFlag=1;
        end
    end
    if(SpanFlag==0 && sum(i)<N)
        warning('Relative rotations DO NOT SPAN all the nodes in the VIEW GRAPH');
        pause();break;
    end
end  

if(~QuaternionIP)
    R = quat2rotm(Q);
else
    R = Q;
end
end