%% This function is intended to calculate the values and weights of different loss 
%% functions of a vector of values(v).
% Only the square root of the actual weight function is returned.
function [p,w] = compute_lossfn_values(type,v, param)
    if(nargin<3)
        disp('Number of arguments required:3')
        return;
    end
    if(strcmp(type,'Geman-McClure'))
        %param will be alpha and the loss function is assumed as 
        % p(x) = alpha^2*x^2/(2*(alpha^2+x^2))
        % w(x) = alpha^2/(alpha^2+x^2) 
        p = param^2*v.^2./(2*(param^2+v.^2));
        w = param^2./(param^2+v.^2);
    elseif(strcmp(type,'Huber'))
        ind = find(abs(v)>=param);
        p = v.^2/2;
        w = ones(size(v));
        p(ind) = param*(abs(v(ind))-param/2);
        w(ind) = sqrt(param./abs(v(ind)));
    elseif(strcmp(type,'l1-l2')) %also known as pseudo-huber
        p = param^2*(sqrt(1+v.^2/param^2)-1);
        w = 1./((1+v.^2/param^2).^(1/4));
    elseif(strcmp(type,'Welsch'))
        p = param^2/2*(1-exp(-(v/param).^2));
        w = sqrt(exp(-(v/param).^2));
    elseif(strcmp(type,'Cauchy'))
        p = param^2/2*log(1+(v/param).^2);
        w = 1./sqrt(1+(v/param).^2);
    elseif(strcmp(type,'Tukey')) %Tukeys Biweight or Bisquare
        ind = find(abs(v)<=param);
        p = zeros(size(v));
        w = zeros(size(v));
        p(ind) = param^2/6*(1-(1-(v(ind)/param).^2).^3);
        w(ind) = 1-(v(ind)/param).^2;
    end
end