function [Ebest,eall,R2,E]=CompareRotationGraph(R1,R2,AlignMethod)
i=min([size(R1,3),size(R2,3)]);R1(:,:,i+1:end)=[];R2(:,:,i+1:end)=[];
i=~(any(any(isnan(R1),1),2)|sum(sum(R1.*R1,1),2)==0|any(any(isnan(R2),1),2)|sum(sum(R2.*R2,1),2)==0);
R1=R1(:,:,i);R2=R2(:,:,i);I=i;

if(nargin<3);AlignMethod='mean';end;
SIGMA2=(5*pi/180)^2;
N=size(R1,3);


Emeanbest=inf;E=[0 0 0];Ebest=E;e=zeros(N,1);ebest=e;
Q1 = rotm2quat(R1);
Q2 = rotm2quat(R2);
for t=1:100
    j=randi(N,1);
    Q = quatinv(Q1(j,:)); Q1 = quatmultiply(Q1,Q);
    Q = quatinv(Q2(j,:)); Q2 = quatmultiply(Q2,Q);
    R1 = quat2rotm(Q1);
    d=inf;count = 1;
    while(d>1e-5)
        temp = quat2axang(quatmultiply(quatinv(Q2),Q1));
        W = temp(:,1:3).*temp(:,4);

        if(strcmp(AlignMethod,'mean'))
            w=mean(W);
            d=norm(w);    %R=w2R(w);
            w1 = w/norm(w);
            w = [w1,norm(w)];
            Q = axang2quat(w);
        elseif(strcmp(AlignMethod,'median'))
            w=median(W);
            d=norm(w);    R=w2R(w);
        elseif(strcmp(AlignMethod,'robustmean'))
            w=1./sqrt((sum((W.*W),2)+SIGMA2));w=w/sum(w);
            w=mean(repmat(w,[1,3]).*W);
            d=norm(w);    R=w2R(w);
        else
            error('Undefined AlignMethod');
        end

        Q2 = quatmultiply(Q2,Q);
        R2 = quat2rotm(Q2);
        count = count+1;
    end

    for i=1:N
        e(i,1)=acos(max(min((R1(1,:,i)*R2(1,:,i)'+R1(2,:,i)*R2(2,:,i)'+R1(3,:,i)*R2(3,:,i)'-1)/2,1),-1));
    end
    e=e*180/pi;
    E=[mean(e) median(e) sqrt(e'*e/size(e,1))];
    if(E(2)<Emeanbest);
        ebest=e;Ebest=E;
    end
end
fprintf('#Common=%d; Angular Error (Degrees): Mean=%.2f; Median=%.2f; RMS=%.2f\n',length(ebest),round(Ebest(1,1)*100)/100,round(Ebest(1,2)*100)/100,round(Ebest(1,3)*100)/100);
eall=nan(length(I),1);eall(I)=ebest;
end
