% Copyright (C) 2024 Computer Vision Lab, Electrical Engineering, 
% Indian Institute of Science, Bengaluru, India.
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
% 
%     * Redistributions of source code must retain the above copyright
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above
%       copyright notice, this list of conditions and the following
%       disclaimer in the documentation and/or other materials provided
%       with the distribution.
%     * Neither the name of Indian Institute of Science nor the
%       names of its contributors may be used to endorse or promote products
%       derived from this software without specific prior written permission.
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
% OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
% THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
% DEALINGS IN THE SOFTWARE.
% 
% Author: Lalit Manam
%
% This file is a part of the implementation for the paper:
% Lalit Manam and Venu Madhav Govindu, Fusing Directions and Displacements in Translation Averaging, 
% International Conference on 3D Vision, 2024 

% Demo for Fused TA paper
clear; close all;

%% Load data
% The data should contain the following:
% RT: 3 x M matrix containing the relative directions all of which are
% placed in the same coordinate frame.
% edges: M X 2 matrix containing the edges list.

load('demo_data.mat');

RT=RT./vecnorm(RT,2,1);
maxImages=max(edges(:));

%% Translation Averaging by Fused TA
% Parameters 
param.delta = 1e-5;
param.numofiterinit = 50;
param.relerrthreinit = 1e-5;
param.numofouteriter = 100;
param.numofinneriter = 5;
param.robustthreRLUD = 1e-1;
param.robustthreBATA = 1e-1;
param.relerrthreouter = 1e-6;
param.relchangethreouter = 1e-5;
param.relchangethreinner = 1e-3;

% Relabelling nodes
nodes=unique(edges(:));
G=graph(edges(:,1),edges(:,2),1:size(edges,1));
D=degree(G); [~,loc]=max(D); idxConst=find(nodes==loc);
G1=subgraph(G,nodes);
P=G1.Edges;
edges_sg=P.EndNodes;
idx=find(edges(:,1)>edges(:,2));
edge_idx_map=P.Weight;
RT(:,idx)=-RT(:,idx);
RT_sg=RT(:,edge_idx_map);

C_avg_temp=Fused_TA(edges_sg',RT_sg,param);

% Remapping back to old positions
C_avg=nan(3,maxImages);
C_avg(:,nodes)=C_avg_temp;
